/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.Pop3ClientEvent;
import apiipc.generated.events.Pop3ClientEventListener;
import apiipc.generated.sim.Pop3Client;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pop3ClientEventRegistry
extends IPCEventRegistry {
    protected Set<Pop3ClientEventListener> globalListeners = new HashSet<Pop3ClientEventListener>();
    protected Map<String, Set<Pop3ClientEventListener>> specificObjectListeners = new HashMap<String, Set<Pop3ClientEventListener>>();

    public Pop3ClientEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "Pop3Client";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        Pop3ClientEvent pop3ClientEvent = null;
        if (string.equalsIgnoreCase("mailReceived")) {
            pop3ClientEvent = new Pop3ClientEvent.MailReceived(iPCEventLTV);
        } else if (string.equalsIgnoreCase("errorReceivingMail")) {
            pop3ClientEvent = new Pop3ClientEvent.ErrorReceivingMail(iPCEventLTV);
        } else {
            return;
        }
        for (Pop3ClientEventListener object : this.globalListeners) {
            object.handleEvent(pop3ClientEvent);
        }
        Set<Pop3ClientEventListener> set = this.specificObjectListeners.get(pop3ClientEvent.objectUUID.toString());
        if (set != null) {
            for (Pop3ClientEventListener pop3ClientEventListener : set) {
                pop3ClientEventListener.handleEvent(pop3ClientEvent);
            }
        }
    }

    public void addListenerFiltered(Pop3ClientEventListener pop3ClientEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("mailReceived");
                this.register("errorReceivingMail");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(pop3ClientEventListener);
    }

    public void addSpecificListenerFiltered(Pop3ClientEventListener pop3ClientEventListener, Pop3Client pop3Client, List<String> list) throws IOException {
        UUID uUID = pop3Client.getObjectUUID();
        String string = uUID.toString();
        Set<Pop3ClientEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<Pop3ClientEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "mailReceived");
                this.register(uUID, "errorReceivingMail");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(pop3ClientEventListener);
    }

    public void removeListenerFiltered(Pop3ClientEventListener pop3ClientEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("mailReceived");
                this.deregister("errorReceivingMail");
            }
            this.globalListeners.remove(pop3ClientEventListener);
        }
    }

    public void removeSpecificListenerFiltered(Pop3ClientEventListener pop3ClientEventListener, Pop3Client pop3Client, List<String> list) throws IOException {
        UUID uUID = pop3Client.getObjectUUID();
        String string = uUID.toString();
        Set<Pop3ClientEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "mailReceived");
            this.deregister(uUID, "errorReceivingMail");
            set.remove(pop3ClientEventListener);
        }
    }

    public void addListener(Pop3ClientEventListener pop3ClientEventListener) throws IOException {
        this.addListenerFiltered(pop3ClientEventListener, null);
    }

    public void addListener(Pop3ClientEventListener pop3ClientEventListener, Pop3Client pop3Client) throws IOException {
        this.addSpecificListenerFiltered(pop3ClientEventListener, pop3Client, null);
    }

    public void removeListener(Pop3ClientEventListener pop3ClientEventListener) throws IOException {
        this.removeListenerFiltered(pop3ClientEventListener, null);
    }

    public void removeListener(Pop3ClientEventListener pop3ClientEventListener, Pop3Client pop3Client) throws IOException {
        this.removeSpecificListenerFiltered(pop3ClientEventListener, pop3Client, null);
    }
}

